﻿-- Creating table 'GF_BetHistory'
CREATE TABLE [dbo].[GF_BetHistory] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Date] datetime  NOT NULL,
    [Balance] float  NOT NULL,
    [AmountWon] float  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [GF_TournamentUser_Id] int  NOT NULL
);
GO

-- Creating primary key on [Id] in table 'GF_BetHistory'
ALTER TABLE [dbo].[GF_BetHistory]
ADD CONSTRAINT [PK_GF_BetHistory]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating foreign key on [GF_TournamentUser_Id] in table 'GF_BetHistory'
ALTER TABLE [dbo].[GF_BetHistory]
ADD CONSTRAINT [FK_GF_TournamentUserGF_BetHisory]
    FOREIGN KEY ([GF_TournamentUser_Id])
    REFERENCES [dbo].[GF_TournamentUser]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentUserGF_BetHisory'
CREATE INDEX [IX_FK_GF_TournamentUserGF_BetHisory]
ON [dbo].[GF_BetHistory]
    ([GF_TournamentUser_Id]);
GO